/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskDHCPChecks;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DHCPComponent
extends Component {
    DHCPComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        boolean isPreCrsInst = false;
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet, true);
        if (null == crsNodes) {
            crsNodes = new String[validNodeArr.length];
            System.arraycopy(validNodeArr, 0, crsNodes, 0, validNodeArr.length);
            isPreCrsInst = true;
        }
        this.validateNetworksArg(validNodeArr[0]);
        switch (this.m_verificationType) {
            case 28: {
                TaskDHCPChecks taskDHCPI = new TaskDHCPChecks(crsNodes);
                taskDHCPI.setPreCheck(isPreCrsInst);
                Trace.out((String)"\n>>>> DHCPComponent:: Upload taskDHCPI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskDHCPI.getResultSet());
                return retval &= taskDHCPI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    private boolean validateNetworksArg(String node) {
        if (!this.m_paramMgr.hasArgument(Argument.ARG_NETWORKLIST)) {
            return true;
        }
        Argument argInterfaceList = this.m_paramMgr.getArgument(Argument.ARG_NETWORKLIST);
        ClusterNetworkInfo cnInfo = null;
        try {
            cnInfo = ClusterNetworkInfo.getNetworkInfoFromPMArg(argInterfaceList, node);
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            Trace.out((String)("Exception occured while getting network information. msg=" + errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        String strInterConnectList = cnInfo.getInterConnectList();
        VerificationUtil.setVariableValue("INTERCONNECT_LIST", strInterConnectList);
        return true;
    }

    @Override
    public String getComponentName() {
        return "DHCP";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9985", false);
    }
}

